/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.runelic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.runelic.Constants;
import net.darkhax.runelic.mixin.AccessorSignBlockEntity;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class RunelicCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean isDedicated) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"runelic");
        root.then(Commands.m_82127_((String)"say").then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(RunelicCommands::commandSay)));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hand").requires(p -> p.m_6761_(2))).executes(RunelicCommands::commandHand));
        LiteralArgumentBuilder book = (LiteralArgumentBuilder)Commands.m_82127_((String)"book").requires(p -> p.m_6761_(2));
        book.then(Commands.m_82127_((String)"encode").executes(ctx -> RunelicCommands.commandBook((CommandContext<CommandSourceStack>)ctx, Constants.FONT_RUNELIC)));
        book.then(Commands.m_82127_((String)"decode").executes(ctx -> RunelicCommands.commandBook((CommandContext<CommandSourceStack>)ctx, Constants.FONT_DEFAULT)));
        root.then((ArgumentBuilder)book);
        LiteralArgumentBuilder tile = (LiteralArgumentBuilder)Commands.m_82127_((String)"tile").requires(p -> p.m_6761_(2));
        tile.then(Commands.m_82127_((String)"encode").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> RunelicCommands.commandPos((CommandContext<CommandSourceStack>)ctx, Constants.FONT_RUNELIC))));
        tile.then(Commands.m_82127_((String)"decode").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> RunelicCommands.commandPos((CommandContext<CommandSourceStack>)ctx, Constants.FONT_DEFAULT))));
        root.then((ArgumentBuilder)tile);
        dispatcher.register(root);
    }

    private static int commandSay(CommandContext<CommandSourceStack> ctx) {
        Component inputMessage = RunelicCommands.applyFont((Component)new TextComponent(StringArgumentType.getString(ctx, (String)"text")), Constants.FONT_RUNELIC);
        TranslatableComponent txtMessage = new TranslatableComponent("chat.type.announcement", new Object[]{((CommandSourceStack)ctx.getSource()).m_81357_(), inputMessage});
        Entity sender = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (sender != null) {
            ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11264_((Component)txtMessage, ChatType.CHAT, sender.m_142081_());
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11264_((Component)txtMessage, ChatType.SYSTEM, Util.f_137441_);
        }
        return 1;
    }

    private static int commandHand(CommandContext<CommandSourceStack> ctx) {
        Entity sender = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (sender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sender;
            ItemStack stack = living.m_21205_();
            stack.m_41714_(RunelicCommands.applyFont(stack.m_41786_(), Constants.FONT_RUNELIC));
        }
        return 1;
    }

    private static int commandPos(CommandContext<CommandSourceStack> ctx, ResourceLocation font) throws CommandSyntaxException {
        BlockPos pos;
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BlockEntity tile = world.m_7702_(pos = BlockPosArgument.m_118242_(ctx, (String)"pos"));
        if (tile != null) {
            if (tile instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)tile;
                container.m_58638_(RunelicCommands.applyFont(container.m_7755_(), font));
            }
            if (tile instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)tile;
                for (int i = 0; i < 4; ++i) {
                    Component component = sign.m_155706_(i, false);
                    if (component == null) continue;
                    sign.m_59732_(i, RunelicCommands.applyFont((Component)component.m_6881_(), font));
                }
                ((AccessorSignBlockEntity)sign).runelic$markUpdated();
            }
        }
        return 1;
    }

    private static int commandBook(CommandContext<CommandSourceStack> ctx, ResourceLocation font) throws CommandSyntaxException {
        LivingEntity living;
        ItemStack stack;
        Item item;
        Entity sender = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (sender instanceof LivingEntity && (item = (stack = (living = (LivingEntity)sender).m_21205_()).m_41720_()) instanceof WrittenBookItem) {
            WrittenBookItem book = (WrittenBookItem)item;
            if (stack.m_41782_()) {
                stack.m_41714_(RunelicCommands.applyFont(stack.m_41786_(), font));
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag != null) {
                    ListTag pageData = stackTag.m_128437_("pages", 8);
                    for (int pageNum = 0; pageNum < pageData.size(); ++pageNum) {
                        MutableComponent pageText = Component.Serializer.m_130714_((String)pageData.m_128778_(pageNum));
                        RunelicCommands.applyFont((Component)pageText, font);
                        pageData.set(pageNum, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)pageText)));
                    }
                    stackTag.m_128365_("pages", (Tag)pageData);
                }
            }
        }
        return 1;
    }

    private static Component applyFont(Component text, ResourceLocation font) {
        if (text instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)text;
            mutable.m_6270_(text.m_7383_().m_131150_(font));
        }
        text.m_7360_().forEach(sib -> RunelicCommands.applyFont(sib, font));
        return text;
    }
}

